<?php
/*--------------------------------------------------------------
   WidgetDefinition.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\Options;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\Titles;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Author;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Icon;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Type;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Version;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Visualization;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;

interface WidgetDefinition
{
    /**
     * Return type.
     */
    public function type(): Type;
    
    
    /**
     * Return version.
     */
    public function version(): Version;
    
    
    /**
     * Return author.
     */
    public function author(): Author;
    
    
    /**
     * Return icon.
     */
    public function icon(): Icon;
    
    
    /**
     * Return title.
     */
    public function titles(): Titles;
    
    
    /**
     * Return visualization.
     */
    public function visualization(): Visualization;
    
    
    /**
     * Return options.
     */
    public function options(): Options;
    
    
    /**
     * Return data.
     */
    public function data(Options $options): Data;
}